import 'package:photogram_admin_cp/import/core.dart';
import 'package:photogram_admin_cp/import/data.dart';

class SettingModel extends AbstractModel {
  @override
  int get intId => _intId;
  String get id => _stringId;

  // primary key

  late final int _intId;
  late final String _stringId;

  // creds

  late String _key;
  late String _value;
  late String _updatedValue;

  // stamp

  late String _stampLastUpdate;
  late String _stampRegistration;

  /*
  |--------------------------------------------------------------------------
  | getters:
  |--------------------------------------------------------------------------
  */

  String get key => _key;
  String get value => _value;

  // stamp

  String get stampLastUpdate => _stampLastUpdate;
  String get stampRegistration => _stampRegistration;

  // helpers

  bool get isChanged => _value != _updatedValue;
  String get updatedValue => _updatedValue;

  bool get isOn => _updatedValue == '1';

  /*
  |--------------------------------------------------------------------------
  | factory:
  |--------------------------------------------------------------------------
  */

  SettingModel();

  factory SettingModel.none() => SettingModel();

  /*
  |--------------------------------------------------------------------------
  | from json:
  |--------------------------------------------------------------------------
  */

  SettingModel.fromJson(Map<String, dynamic> jsonMap) {
    /*
    |--------------------------------------------------------------------------
    | try setting all fields:
    |--------------------------------------------------------------------------
    */
    try {
      // primary key

      _intId = AppUtils.intVal(jsonMap[SettingTable.id]);

      _stringId = jsonMap[SettingTable.id];

      // creds

      _key = jsonMap[SettingTable.key] ?? ''; // private
      _value = jsonMap[SettingTable.value];
      _updatedValue = jsonMap[SettingTable.value];

      // stamps

      _stampLastUpdate = jsonMap[SettingTable.stampLastUpdate];

      _stampRegistration = jsonMap[SettingTable.stampRegistration] ?? ''; // private

      isModel = true;

      /*
      |--------------------------------------------------------------------------
      | failed
      |--------------------------------------------------------------------------
      */
    } catch (e) {
      AppLogger.info(e, logType: AppLogType.parser);
    }
  }

  Map<String, dynamic> toJson() => <String, dynamic>{
        SettingTable.id: id,

        // creds

        SettingTable.key: key,
        SettingTable.value: updatedValue,

        // stamp

        SettingTable.stampLastUpdate: stampLastUpdate,
        SettingTable.stampRegistration: stampRegistration,
      };

  @override
  void mergeChanges(dynamic receivedModel) {
    receivedModel as SettingModel;

    // creds

    _key = receivedModel.key;
    _value = receivedModel.value;

    _updatedValue = receivedModel.value;

    // stamps

    _stampLastUpdate = receivedModel.stampLastUpdate;
    _stampRegistration = receivedModel.stampRegistration;
  }

  /*
  |--------------------------------------------------------------------------
  | client specific implementation:
  |--------------------------------------------------------------------------
  */

  void update(String updatedValue) => _updatedValue = updatedValue;
}
